<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class ScienceCitationAlternateTitle extends \Google\Model
{
  protected $internal_gapi_mappings = [
        "language" => "Language",
        "title" => "Title",
        "titleHtml" => "TitleHtml",
        "titleHtmlLeftOver" => "TitleHtmlLeftOver",
  ];
  /**
   * @var string
   */
  public $language;
  /**
   * @var string
   */
  public $title;
  /**
   * @var string
   */
  public $titleHtml;
  /**
   * @var string
   */
  public $titleHtmlLeftOver;

  /**
   * @param string
   */
  public function setLanguage($language)
  {
    $this->language = $language;
  }
  /**
   * @return string
   */
  public function getLanguage()
  {
    return $this->language;
  }
  /**
   * @param string
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
  /**
   * @param string
   */
  public function setTitleHtml($titleHtml)
  {
    $this->titleHtml = $titleHtml;
  }
  /**
   * @return string
   */
  public function getTitleHtml()
  {
    return $this->titleHtml;
  }
  /**
   * @param string
   */
  public function setTitleHtmlLeftOver($titleHtmlLeftOver)
  {
    $this->titleHtmlLeftOver = $titleHtmlLeftOver;
  }
  /**
   * @return string
   */
  public function getTitleHtmlLeftOver()
  {
    return $this->titleHtmlLeftOver;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ScienceCitationAlternateTitle::class, 'Google_Service_Contentwarehouse_ScienceCitationAlternateTitle');
